//	CFileCpm.h

#ifndef _H_CFileCpm
#define _H_CFileCpm

#include "CpmStructs.h"
#include "CFile.h"

char		*Cpm_GetName(Cpm_DirEntry *entryP, char *bufAC);
char		*Cpm_GetDescription(Cpm_DirEntry *entryP, char *bufAC);
OSType		Cpm_GetFileOSType(Cpm_DirEntry *entryP);
Boolean		Cpm_MatchName(Cpm_DirEntry *entry1P, Cpm_DirEntry *entry2P);

void		GetTypeName(
	Cpm_DirEntry			*entryP, 
	Cpm_FileNameStr			nameZ0, 
	Cpm_FileTypeStr			typeZ0, 
	Cpm_AccessBits			*bits0, 
	Cpm_FileNameAndTypeStr	typeNameZ);

void		Cpm_SetNameOnAllEntries(
	Cpm_DirEntry			*entryP, 
	Cpm_FileNameAndTypeStr	typeNameZ);

void		Cpm_GetTypeName(
	Cpm_FileNameStr			nameZ, 
	Cpm_FileTypeStr			typeZ, 
	Cpm_AccessBits			*bitsP, 
	Cpm_FileNameAndTypeStr	typeNameZ);

Cpm_AccessBits		Cpm_GetAccessBits(Cpm_DirEntry *entryP);
void				Cpm_SetAccessBits(Cpm_DirEntry *entryP, Cpm_AccessBits cpmBits);

class CFileCpm : public CFile {
	
	public:
	
	OSErr		IFileCpm(
		CDiskCpm			*cDisk, 
		CFolderCpm			*cParentFolderCpm, 
		Cpm_BlockNum		block, 
		Cpm_EntryIndex		diskLocDirEntryIndex,	//	relative to cur dir sector
		Cpm_EntryIndex		directoryIndex			//	relative to entire directory
	);
	
	Cpm_DirEntry		*GetMyEntry(void);
	
	OSType				GetCpmFileOSType(void);

	virtual	ushort		GetLoadAddress(void);
	virtual	void		SetLoadAddress(ushort address);
	
	Cpm_AccessBits		GetCpmAccessBits(void);
	void				GetAccessBits(Gen_AccessBits *bits);
	void				SetAccessBits(Gen_AccessBits *bits);
	virtual char		*GetDescription(char *buf);

	virtual ulong		GetPhysicalSize(void);
	virtual ulong		GetLogicalSize(void);

	virtual	DateTimeRec	*GetModifiedTime(DateTimeRec *dt);

	virtual	char		*GetName(char *buf);
	virtual	OSErr 		ReadFile(Byte *buffer, long length);
	virtual	OSErr 		WriteFile(Byte *buffer, long length);
	virtual ADFS_IconType		GetIconType(void);

	virtual	void		SetName(char *buf);
	virtual	OSErr		Delete(Boolean warnB = FALSE, CDialogCopy *copyP0 = NULL);
	virtual	OSErr		UnDelete(Boolean recursiveB = FALSE, CDialogCopy *copyP0 = NULL);

	virtual	ushort		GetFileType_ProEquiv(void);
	virtual	void		SetFileType_ProEquiv(Byte proType);
	virtual	ulong		ADFS_GetBufSize(void);

	OSErr		Cpm_GetIndBlockNum(
		Cpm_BlockNum blockIndex, 
		Cpm_BlockNum *blockNum);

	OSErr		ADFS_Read(ushort *bytesRead);

	OSErr		Cpm_WriteBlock(
		ushort		numBytesS, 
		Cpm_Block	*sectorBufP);
		
	OSErr		ADFS_Write(ushort *bytesWritten);
	
	OSErr		ADFS_Close(void);

	OSErr		GetFileBlocks(
		Cpm_BlockNum	*fileBlockA0, 
		Cpm_BlockNum	*numFileBlocksSP);

	OSErr		GetEntryAlloc(
		Boolean			getAsBlocksB, 
		Gen_EntryAlloc	**sectorListH);

	private:
	typedef CFile _inherited;
};

#endif
